/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;

public class HangmanClient
extends Applet {
    private Choice ivjcategoryChoice = null;
    private Button ivjgiveUpButton = null;
    private Label ivjmysteryLabel = null;
    private Panel ivjPanel1 = null;
    private Panel ivjPanel2 = null;
    private GridLayout ivjPanel2GridLayout = null;
    private Panel ivjPanel3 = null;
    private FlowLayout ivjPanel3FlowLayout = null;
    private Label ivjremainingOpportunitiesLabel = null;
    private Button ivjstartButton = null;
    private GridLayout ivjPanel1GridLayout = null;
    private StickMan stickMan;
    private Socket socket = null;
    private BufferedReader input = null;
    private PrintWriter output = null;
    private Button[] buttons = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler(this);
    private Label ivjcategoriesLabel = null;
    private BorderLayout ivjHangmanClientBorderLayout = null;

    private void close() {
        try {
            if (this.output != null) {
                this.output.close();
            }
            if (this.input != null) {
                this.input.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {}
    }

    private void connEtoC1(ActionEvent actionEvent) {
        try {
            this.startButton_ActionPerformed();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC2(ActionEvent actionEvent) {
        try {
            this.giveUpButton_ActionPerformed();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void enableGame() {
        this.getstartButton().setEnabled(false);
        this.getgiveUpButton().setEnabled(true);
        this.getcategoriesLabel().setEnabled(false);
        this.getcategoryChoice().setEnabled(false);
        int n = 0;
        while (n < this.buttons.length) {
            this.buttons[n].setEnabled(true);
            ++n;
        }
    }

    private void enablePreGame() {
        this.getstartButton().setEnabled(true);
        this.getgiveUpButton().setEnabled(false);
        this.getcategoriesLabel().setEnabled(true);
        this.getcategoryChoice().setEnabled(true);
        int n = 0;
        while (n < this.buttons.length) {
            this.buttons[n].setEnabled(false);
            ++n;
        }
    }

    public String getAppletInfo() {
        return "HangmanClient\n\nApplet client for the Three-tier Hangman.\nCopyright (C) 2000 Ariel Ortiz mailto:aortiz@acm.org\n";
    }

    private Label getcategoriesLabel() {
        if (this.ivjcategoriesLabel == null) {
            try {
                this.ivjcategoriesLabel = new Label();
                this.ivjcategoriesLabel.setName("categoriesLabel");
                this.ivjcategoriesLabel.setAlignment(2);
                this.ivjcategoriesLabel.setText("Categories:");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjcategoriesLabel;
    }

    private Choice getcategoryChoice() {
        if (this.ivjcategoryChoice == null) {
            try {
                this.ivjcategoryChoice = new Choice();
                this.ivjcategoryChoice.setName("categoryChoice");
                this.ivjcategoryChoice.setFont(new Font("dialog", 0, 14));
                this.ivjcategoryChoice.add("all");
                this.ivjcategoryChoice.add("animals");
                this.ivjcategoryChoice.add("movies");
                this.ivjcategoryChoice.add("computer people");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjcategoryChoice;
    }

    private Button getgiveUpButton() {
        if (this.ivjgiveUpButton == null) {
            try {
                this.ivjgiveUpButton = new Button();
                this.ivjgiveUpButton.setName("giveUpButton");
                this.ivjgiveUpButton.setFont(new Font("dialog", 0, 14));
                this.ivjgiveUpButton.setEnabled(false);
                this.ivjgiveUpButton.setLabel("Give Up!");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjgiveUpButton;
    }

    private BorderLayout getHangmanClientBorderLayout() {
        BorderLayout borderLayout = null;
        try {
            borderLayout = new BorderLayout();
            borderLayout.setVgap(10);
            borderLayout.setHgap(10);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
        return borderLayout;
    }

    private Label getmysteryLabel() {
        if (this.ivjmysteryLabel == null) {
            try {
                this.ivjmysteryLabel = new Label();
                this.ivjmysteryLabel.setName("mysteryLabel");
                this.ivjmysteryLabel.setFont(new Font("monospaced", 0, 18));
                this.ivjmysteryLabel.setAlignment(1);
                this.ivjmysteryLabel.setText("");
                this.ivjmysteryLabel.setBackground(Color.lightGray);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjmysteryLabel;
    }

    private Panel getPanel1() {
        if (this.ivjPanel1 == null) {
            try {
                this.ivjPanel1 = new Panel();
                this.ivjPanel1.setName("Panel1");
                this.ivjPanel1.setLayout(this.getPanel1GridLayout());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjPanel1;
    }

    private GridLayout getPanel1GridLayout() {
        GridLayout gridLayout = null;
        try {
            gridLayout = new GridLayout(4, 7);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
        return gridLayout;
    }

    private Panel getPanel2() {
        if (this.ivjPanel2 == null) {
            try {
                this.ivjPanel2 = new Panel();
                this.ivjPanel2.setName("Panel2");
                this.ivjPanel2.setLayout(this.getPanel2GridLayout());
                this.getPanel2().add((Component)this.getremainingOpportunitiesLabel(), this.getremainingOpportunitiesLabel().getName());
                this.getPanel2().add((Component)this.getPanel3(), this.getPanel3().getName());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjPanel2;
    }

    private GridLayout getPanel2GridLayout() {
        GridLayout gridLayout = null;
        try {
            gridLayout = new GridLayout(2, 1);
            gridLayout.setHgap(10);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
        return gridLayout;
    }

    private Panel getPanel3() {
        if (this.ivjPanel3 == null) {
            try {
                this.ivjPanel3 = new Panel();
                this.ivjPanel3.setName("Panel3");
                this.ivjPanel3.setLayout(this.getPanel3FlowLayout());
                this.ivjPanel3.setBackground(Color.lightGray);
                this.getPanel3().add((Component)this.getstartButton(), this.getstartButton().getName());
                this.getPanel3().add((Component)this.getgiveUpButton(), this.getgiveUpButton().getName());
                this.getPanel3().add((Component)this.getcategoriesLabel(), this.getcategoriesLabel().getName());
                this.getPanel3().add((Component)this.getcategoryChoice(), this.getcategoryChoice().getName());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjPanel3;
    }

    private FlowLayout getPanel3FlowLayout() {
        FlowLayout flowLayout = null;
        try {
            flowLayout = new FlowLayout();
            flowLayout.setVgap(5);
            flowLayout.setHgap(15);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
        return flowLayout;
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"middletierhost", "URL", "IP address or domain name of middle tier server"}, {"middletierport", "Number", "Port number"}};
        return stringArray;
    }

    private Label getremainingOpportunitiesLabel() {
        if (this.ivjremainingOpportunitiesLabel == null) {
            try {
                this.ivjremainingOpportunitiesLabel = new Label();
                this.ivjremainingOpportunitiesLabel.setName("remainingOpportunitiesLabel");
                this.ivjremainingOpportunitiesLabel.setAlignment(1);
                this.ivjremainingOpportunitiesLabel.setFont(new Font("dialog", 0, 14));
                this.ivjremainingOpportunitiesLabel.setText("Press start button to begin playing...");
                this.ivjremainingOpportunitiesLabel.setBackground(Color.lightGray);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjremainingOpportunitiesLabel;
    }

    private Button getstartButton() {
        if (this.ivjstartButton == null) {
            try {
                this.ivjstartButton = new Button();
                this.ivjstartButton.setName("startButton");
                this.ivjstartButton.setFont(new Font("dialog", 0, 14));
                this.ivjstartButton.setLabel("Start");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjstartButton;
    }

    public void giveUpButton_ActionPerformed() {
        if (this.output != null) {
            this.write("GIVEUP");
            try {
                String string = this.input.readLine();
                if (!string.startsWith("LOST:")) {
                    throw new Exception("Protocol Error!");
                }
                this.getremainingOpportunitiesLabel().setText("You give up! The answer was: " + HangmanClient.strip(string).toUpperCase());
                this.enablePreGame();
            }
            catch (Exception exception) {
                this.getremainingOpportunitiesLabel().setText(exception.toString());
            }
        }
    }

    private void handleException(Throwable throwable) {
    }

    public void init() {
        try {
            super.init();
            this.setName("HangmanClient");
            this.setLayout(this.getHangmanClientBorderLayout());
            this.setBackground(Color.lightGray);
            this.setSize(426, 240);
            this.add((Component)this.getmysteryLabel(), "North");
            this.add((Component)this.getPanel1(), "Center");
            this.add((Component)this.getPanel2(), "South");
            this.initConnections();
            this.stickMan = new StickMan();
            this.add((Component)this.stickMan, "West");
            this.buttons = new Button[26];
            Font font = new Font("dialog", 1, 14);
            ActionListener actionListener = new ActionListener(this){
                /* synthetic */ HangmanClient this$0;

                public void actionPerformed(ActionEvent actionEvent) {
                    HangmanClient.access$letterButton_ActionPerformed(this.this$0, actionEvent);
                }
                {
                    this.this$0 = hangmanClient;
                }
            };
            int n = 0;
            while (n < this.buttons.length) {
                this.buttons[n] = new Button((char)(n + 65) + "");
                this.buttons[n].setFont(font);
                this.buttons[n].addActionListener(actionListener);
                this.getPanel1().add(this.buttons[n]);
                ++n;
            }
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void initConnections() throws Exception {
        this.getstartButton().addActionListener(this.ivjEventHandler);
        this.getgiveUpButton().addActionListener(this.ivjEventHandler);
    }

    private static String insertSpaces(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            stringBuffer.append(Character.toUpperCase(string.charAt(n)));
            stringBuffer.append(' ');
            ++n;
        }
        return stringBuffer.toString();
    }

    private void letterButton_ActionPerformed(ActionEvent actionEvent) {
        block7: {
            if (this.output != null) {
                this.write("CONTAINS:" + actionEvent.getActionCommand().toLowerCase());
                ((Button)actionEvent.getSource()).setEnabled(false);
                try {
                    String string = this.input.readLine();
                    if (string.startsWith("YES:")) {
                        this.getmysteryLabel().setText(HangmanClient.insertSpaces(HangmanClient.strip(string)));
                        break block7;
                    }
                    if (string.startsWith("WON:")) {
                        this.getmysteryLabel().setText(HangmanClient.insertSpaces(HangmanClient.strip(string)));
                        this.getremainingOpportunitiesLabel().setText("You win!");
                        this.enablePreGame();
                        break block7;
                    }
                    if (string.startsWith("LOST:")) {
                        this.stickMan.setOpportunitiesLeft(0);
                        this.getremainingOpportunitiesLabel().setText("You loose! The answer was: " + HangmanClient.strip(string).toUpperCase());
                        this.enablePreGame();
                        break block7;
                    }
                    if (string.startsWith("NO:")) {
                        int n = Integer.parseInt(HangmanClient.strip(string));
                        this.stickMan.setOpportunitiesLeft(n);
                        this.getremainingOpportunitiesLabel().setText("Opportunities left: " + n);
                        break block7;
                    }
                    throw new Exception("Protocol Error!");
                }
                catch (Exception exception) {
                    this.getremainingOpportunitiesLabel().setText(exception.toString());
                }
            }
        }
    }

    public void start() {
        String string = this.getParameter("middletierhost");
        int n = Integer.parseInt(this.getParameter("middletierport"));
        try {
            this.socket = new Socket(string, n);
            this.input = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.output = new PrintWriter(new OutputStreamWriter(this.socket.getOutputStream()));
            String string2 = this.input.readLine();
            if (!string2.equals("READY")) {
                throw new Exception("Protocol Error!");
            }
            this.enablePreGame();
        }
        catch (Exception exception) {
            this.getremainingOpportunitiesLabel().setText(exception.toString());
            this.setEnabled(false);
        }
    }

    public void startButton_ActionPerformed() {
        try {
            this.write("CHOOSE:" + this.getcategoryChoice().getSelectedItem());
            String string = this.input.readLine();
            if (!string.startsWith("OK:")) {
                throw new Exception("Protocol Error!");
            }
            this.getmysteryLabel().setText(HangmanClient.insertSpaces(HangmanClient.strip(string)));
            this.getremainingOpportunitiesLabel().setText("You may start choosing letters...");
            this.stickMan.setOpportunitiesLeft(-1);
            this.enableGame();
        }
        catch (Exception exception) {
            this.socket = null;
            this.input = null;
            this.output = null;
            this.getremainingOpportunitiesLabel().setText(exception.toString());
        }
    }

    public void stop() {
        this.write("BYE");
        this.close();
    }

    private static String strip(String string) {
        return string.substring(string.indexOf(58) + 1);
    }

    private void write(String string) {
        if (this.output != null) {
            this.output.println(string);
            this.output.flush();
        }
    }

    static Button access$getgiveUpButton(HangmanClient hangmanClient) {
        return hangmanClient.getgiveUpButton();
    }

    static void access$connEtoC2(HangmanClient hangmanClient, ActionEvent actionEvent) {
        hangmanClient.connEtoC2(actionEvent);
    }

    static Button access$getstartButton(HangmanClient hangmanClient) {
        return hangmanClient.getstartButton();
    }

    static void access$connEtoC1(HangmanClient hangmanClient, ActionEvent actionEvent) {
        hangmanClient.connEtoC1(actionEvent);
    }

    static void access$letterButton_ActionPerformed(HangmanClient hangmanClient, ActionEvent actionEvent) {
        hangmanClient.letterButton_ActionPerformed(actionEvent);
    }

    class IvjEventHandler
    implements ActionListener {
        /* synthetic */ HangmanClient this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == HangmanClient.access$getstartButton(this.this$0)) {
                HangmanClient.access$connEtoC1(this.this$0, actionEvent);
            }
            if (actionEvent.getSource() == HangmanClient.access$getgiveUpButton(this.this$0)) {
                HangmanClient.access$connEtoC2(this.this$0, actionEvent);
            }
        }

        IvjEventHandler(HangmanClient hangmanClient) {
            this.this$0 = hangmanClient;
        }
    }
}

